# Efficient-UG: Unified Understanding–Generation Efficiency

This repo contains the evaluation scripts and model wrappers used in our experiments on **neuron partition** and **MoE adaptation** for Omni-models.  
We provide plug-in “modeling” files for **BAGEL**, **Ming-Omni**, and **Qwen-Image**, and a unified evaluation entry for **GenEval** (optionally extensible to other benchmarks).

---

## 1) Environment

Tested with:
- Python 3.10+
- PyTorch ≥ 2.1 (CUDA 11.8/12.x)
- `transformers`, `diffusers`, `accelerate`, `tqdm`, `numpy`, `Pillow`, `scipy`

Create a fresh env (example with conda):
```bash
conda create -n efficient-ug python=3.10 -y
conda activate efficient-ug
pip install torch --index-url https://download.pytorch.org/whl/cu121   # pick the wheel for your CUDA
pip install transformers diffusers accelerate datasets tqdm numpy pillow scipy
```

---

## 2) Repo Layout (key paths)

```
scripts/
  eval/                         # evaluation entry points
    run_geneval.py              # GenEval driver (main entry)

BAGEL/
  modeling/                     # BAGEL modeling adapters

Ming/
  modeling/                     # Ming-Omni modeling adapters

Qwen/
  diffusers/pipelines/qwenimage/  # Qwen-Image pipeline adapters
```

---

## 3) Models & Checkpoints

Supply a HuggingFace model id or a local checkpoint path for the **understanding component** (if you only compress understanding). Examples:
```bash
# Example placeholders — replace with your actual ids/paths
--model_id bagel/7b        # BAGEL
--model_id ming/omni-7b    # Ming-Omni
--model_id qwen/qwen-image # Qwen-Image
# or
--ckpt_path /path/to/checkpoint
```

---

## 4) Run: GenEval

Minimal command:
```bash
python scripts/eval/run_geneval.py   --model_path qwen/qwen-image   --output_dir outputs/geneval/qwen-image-baseline   --batch_size 4   --seed 42
```


